
/*  ************************************************************************  *
 *                                  test.cpp                                  *
 *  ************************************************************************  */

#include    "stdinc.h"

#include    <stdlib.h>

#include    "profseg.h"
#include    "test.h"

/*  ************************************************************************  */

/*  The routine whose execution we want to profile would in real-world use
    be a more substantial encoding of some algorithm. Here, just for
    demonstration, it simply sums rougly half the bytes of a buffer whose
    pseudo-random content may or may not be sorted.

    The key constraint is that we put this routine - and any others that we
    might profile - in a specially prepared section so that we can easily
    know both the start address and size.  */

#pragma PROFILE_CODE_SEG

DECLSPEC_NOINLINE
ULONG Test (BYTE const *Buffer, ULONG Size)
{
    ULONG x = 0;

    BYTE const *p;
    ULONG n;
    for (p = Buffer, n = Size; n != 0; p ++, n --) {
        ULONG b = *p;
        if (b <= 0x7F) x += b;
    }

    return x;
}

#pragma code_seg ()

/*  ************************************************************************  */

/*  Also for demonstration, the buffer the routine works on may as well be
    statically allocated.  */

static BYTE Buffer [0x00010000];        // 64KB

/*  Preparing the test is just a matter of filling the buffer with
    pseudo-random bytes.  */

VOID InitTest (VOID)
{
    srand (0);

    PBYTE p;
    ULONG n;
    for (p = Buffer, n = sizeof (Buffer); n != 0; p ++, n --) {
        *p = (BYTE) rand ();
    }
}

static int __cdecl Compare (void *, void const *p1, void const *p2)
{
    BYTE b1 = *((BYTE const *) p1);
    BYTE b2 = *((BYTE const *) p2);
    return b1 < b2 ? -1 : b1 == b2 ? 0 : 1;
}

VOID ChangeTest (VOID)
{
    qsort_s (
        Buffer,
        RTL_NUMBER_OF (Buffer),
        sizeof (Buffer [0]),
        Compare,
        NULL);
}

ULONG RunTest (VOID)
{
    return Test (Buffer, sizeof (Buffer));
}

/*  ************************************************************************  */

