
/*  ************************************************************************  *
 *                                  stdinc.h                                  *
 *  ************************************************************************  */

/*  Common inclusion for user-mode Windows programming in general - include
    first in every source file  */

#pragma once

/*  ************************************************************************  */
/*  For using the Windows Software Development Kit (SDK)  */

/*  Windows API functions work better with wide-character strings. Remember,
    defining UNICODE (not _UNICODE) does not affect the C Run-Time (CRT)
    library, just Windows.  */

#define     UNICODE

/*  Include WINDOWS.H, as pretty much required of all user-mode programming
    for Windows. That said, very rarely do we need all the very many headers
    that WINDOWS.H ordinarily brings us. The usual way to cut down the
    inclusions is to define the WIN32_LEAN_AND_MEAN macro (to anything) in
    advance. Building with the Windows Driver Kit does this by default
    (defining the macro to 1, specifically), but we may as well make
    explicit that we would want this by default or not.  */

#define     WIN32_LEAN_AND_MEAN     1
#include    <windows.h>

/*  Building with the Windows Driver Kit causes nearly two dozen warnings to
    be disabled via a forced inclusion. Code is more easily (and better)
    maintained if it compiles without warnings, even seemingly trivial ones.

    For some warnings, the forced inclusion raises the level. Some warnings
    even get promoted to errors. Happily accept all these, but undo all the
    forced inclusion's other changes.  */

#ifndef _PREFAST_
#pragma warning (default : 4068)
#endif
#pragma warning (default : 4071)
#if _DBG_MEMCPY_INLINE_
#pragma warning (default : 4163)
#endif
#pragma warning (default : 4206)
#pragma warning (default : 4263)
#pragma warning (default : 4264)
#pragma warning (default : 4274)
#pragma warning (default : 4306)
#pragma warning (default : 4324)
#if _MSC_VER > 1300
#pragma warning (default : 4356)
#endif
#if _MSC_FULL_VER >= 140040702
#pragma warning (default : 4430)
#pragma warning (default : 4431)
#endif
#pragma warning (default : 4503)
#if _MSC_VER > 1400
#pragma warning (default : 4603)
#pragma warning (default : 4627)
#endif
#if _MSC_VER > 1300
#pragma warning (default : 4675)
#endif
#pragma warning (default : 4710)
#ifdef _M_IA64
#pragma warning (default : 4714)
#endif
#pragma warning (default : 4786)
#if _MSC_FULL_VER >= 140040702
#pragma warning (default : 4812)
#endif
#pragma warning (default : 4826)
#pragma warning (default : 4917)

/*  It may seem a bit excessive to want to compile without warnings even
    under /Wall but some of the warnings that /Wall enables are useful,
    e.g., for keeping the programmer aware of sign in conversions between
    integer types, and a careful programmer can stand to enable most without
    much trouble.

    The few warnings we keep disabled, immediately below, are anyway raised
    by code from Microsoft, notably the headers generated by the Windows
    Pre-Processing (WPP) tool for software tracing: we can't do much about
    that!  */

#pragma warning (disable : 4061)
#pragma warning (disable : 4710)
#pragma warning (disable : 4711)

/*  ************************************************************************  */
/*  Things the author simply likes to have as part of his programming style  */

#define AND &&
#define NOT !
#define OR  ||

/*  ************************************************************************  */
/*  PREfast  */

/*  Programmers may think to feed source code to Microsoft's tools for
    static code analysis, particularly the PREfast tool that is supplied
    with recent versions of the Windows Driver Kit (WDK).

    The value of these tools is much diminished by their occasional need for
    cryptic-looking annotations.

    The first annotation is to confirm for these tools that they're reading
    user-mode code. This is anyway the default when PREfast is run via OACR
    and the source code does not include WDM.H (or the until-recently very
    secret NTOSP.H). Microsoft's directions in the WDK documentation are
    that if we do specify the analysis mode, then we should do so as soon as
    possible after including the standard header.

    As some indication of the quirkiness involved in supporting PREfast,
    consider that Microsoft also directs that the annotation for specifying
    the analysis mode should have the form

        __drv_unit (user_code)

    but it seems that only the following, also documented, actually does
    compile.  */

__user_code;

/*  ========================================================================  */

/*  Rightly or wrongly, the author strongly prefers that operator new
    returns NULL on failure rather than throw an exception. Yes, throwing an
    exception is standard for C++ but it's highly unsatisfactory in
    low-level code. Better, it seems is to check for the return of NULL and
    not to plan for handling an exception when asking for new memory.

    This dependence (on not throwing) might well be made explicit just for
    the code's own sake. It anyway must be explicit for Microsoft's
    code-analysis tools.

    While we're at it, we may as well try to have those tools enforce that
    success of operator new must never just be assumed.  */

#ifdef __cplusplus

__checkReturn
__success (return != NULL)
void * __cdecl operator new (size_t) throw ();

void __cdecl operator delete (void *) throw ();

#endif  // #ifdef __cplusplus

/*  ************************************************************************  */

