
/*  ************************************************************************  *
 *                                 profsrc.h                                  *
 *  ************************************************************************  */

/*  This header exists solely for the definition of the KPROFILE_SOURCE
    enumeration.  */

#pragma once

#ifdef __cplusplus
extern "C" {
#endif

/*  Some functions in the profiling API work with a profile source as an
    enumeration that has always been in one or another header for
    device-driver programming but apparently never in any that Microsoft
    publishes for user-mode programming.  */

typedef enum _KPROFILE_SOURCE {
    ProfileTime,
    ProfileAlignmentFixup,
    ProfileTotalIssues,
    ProfilePipelineDry,
    ProfileLoadInstructions,
    ProfilePipelineFrozen,
    ProfileBranchInstructions,
    ProfileTotalNonissues,
    ProfileDcacheMisses,
    ProfileIcacheMisses,
    ProfileCacheMisses,
    ProfileBranchMispredictions,
    ProfileStoreInstructions,
    ProfileFpInstructions,
    ProfileIntegerInstructions,
    Profile2Issue,
    Profile3Issue,
    Profile4Issue,
    ProfileSpecialInstructions,
    ProfileTotalCycles,
    ProfileIcacheIssues,
    ProfileDcacheAccesses,
    ProfileMemoryBarrierCycles,
    ProfileLoadLinkedIssues,
    ProfileMaximum
} KPROFILE_SOURCE;

#ifdef __cplusplus
}   // extern "C"
#endif

/*  ************************************************************************  */

