
/*  ************************************************************************  *
 *                                 profseg.h                                  *
 *  ************************************************************************  */

#pragma once

/*  ************************************************************************  */
/*  Implementation details  */

/*  Pick a base name for a section for code whose execution we want to
    profile, then elaborate the name so that alphabetical ordering after the
    dollar sign gives us markers for the section's start and end.  */

#define PROFILE_START           "PROFILE$A"
#define PROFILE_TEXT            "PROFILE$TEXT"
#define PROFILE_END             "PROFILE$Z"

/*  Tell the compiler that we mean these to name read-only sections that can
    contain code.  */

#pragma code_seg (PROFILE_START)
#pragma code_seg (PROFILE_TEXT)
#pragma code_seg (PROFILE_END)
#pragma code_seg ()

/*  Expose labels at the start and end. Were they implemented in assembly
    language they actually could be just labels. In C and C++ there must be
    storage.  */

extern BYTE const ProfileStart;
extern BYTE const ProfileEnd;

/*  ========================================================================  */
/*  Public  */

/*  Hide the preceding details behind macros.

/*  The PROFILE.CPP implementation of the CProfile helper need use just the
    following to get the address and size of whatever code is to be
    profiled.  */

#define PROFILE_BASE   ((PVOID) &ProfileStart)
#define PROFILE_SIZE   ((SIZE_T) (&ProfileEnd - &ProfileStart))

/*  The code that's to be profiled need know nothing more than to put itself
    in the PROFILE_TEXT section. Give it a choice of pragmas.  */

#define PROFILE_CODE_SEG        code_seg (PROFILE_TEXT)
#define PROFILE_ALLOC_TEXT(f)   alloc_text (PROFILE_TEXT, f)

/*  ************************************************************************  */

