
/*  ************************************************************************  *
 *                                 profapi.h                                  *
 *  ************************************************************************  */

/*  This header exists solely for undocumented and/or kernel-mode Windows
    material to do with profiling. It is separated from PROFILE.CPP just to
    avoid clutter in the source code.  */

#pragma once

#include    "ntddkhlp.h"        // for NTSTATUS

/*  Definition of KPROFILE_SOURCE is separated so that MAIN.CPP can know a
    particular source to use by default.  */

#include    "profsrc.h"         // for KPROFILE_SOURCE

/*  ************************************************************************  */

#ifdef __cplusplus
extern "C" {
#endif

/*  Except for NtCreateProfileEx, all the functions for profiling have been
    in Windows forever.  */

NTSYSAPI
NTSTATUS
NTAPI
NtCreateProfile (
    HANDLE *ProfileHandle,
    HANDLE Process,
    PVOID ProfileBase,
    SIZE_T ProfileSize,
    ULONG BucketSize,
    ULONG *Buffer,
    ULONG BufferSize,
    KPROFILE_SOURCE ProfileSource,
    KAFFINITY Affinity);

#if _WIN32_WINNT >= 0x0601

NTSYSAPI
NTSTATUS
NTAPI
NtCreateProfileEx (
    HANDLE *ProfileHandle,
    HANDLE Process,
    PVOID ProfileBase,
    SIZE_T ProfileSize,
    ULONG BucketSize,
    ULONG *Buffer,
    ULONG BufferSize,
    KPROFILE_SOURCE ProfileSource,
    USHORT GroupCount,
    GROUP_AFFINITY *AffinityArray);

#endif  // #if _WIN32_WINNT >= 0x0601

NTSYSAPI
NTSTATUS
NTAPI
NtStartProfile (
    HANDLE ProfileHandle);

NTSYSAPI
NTSTATUS
NTAPI
NtStopProfile (
    HANDLE ProfileHandle);

NTSYSAPI
NTSTATUS
NTAPI
NtQueryIntervalProfile (
    KPROFILE_SOURCE ProfileSource,
    ULONG *Interval);

NTSYSAPI
NTSTATUS
NTAPI
NtSetIntervalProfile (
    ULONG Interval,
    KPROFILE_SOURCE ProfileSource);

#ifdef __cplusplus
}   // extern "C"
#endif

/*  ************************************************************************  */

