
/*  ************************************************************************  *
 *                                 ntddkhlp.h                                 *
 *  ************************************************************************  */

/*  This header exists just for kernel-mode definitions that are not obvious
    to pick up in user-mode programming. See, for instance, that WINNT.H
    and NTSTATUS.H have conflicting macro definitions of NTSTATUS values.
    It's easier to define just what we need.  */

#pragma once

/*  ************************************************************************  */

/*  The usual definition of the kernel-mode error code and a macro for
    interpreting that it means success  */

typedef __success (return >= 0) LONG NTSTATUS;

#define NT_SUCCESS(Status)          ((NTSTATUS) (Status) >= 0)

/*  Particular error-code values that are relevant to this program but which
    aren't typically picked up from headers for user-mode programming  */

#define STATUS_SUCCESS              ((NTSTATUS) 0)
#define STATUS_PRIVILEGE_NOT_HELD   ((NTSTATUS) 0xC0000061)
#define STATUS_NOT_SUPPORTED        ((NTSTATUS) 0xC00000BB)

/*  For conversion to Win32 error codes, as might be used in the rest of a
    typical user-mode program  */

EXTERN_C NTSYSAPI ULONG NTAPI RtlNtStatusToDosError (NTSTATUS Status);

/*  ************************************************************************  */

